/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.toppings;

import com.itayfeder.gelato_galore.toppings.Toppings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class Topping
implements Cloneable {
    public static final Map<ResourceLocation, Topping> TOPPINGS = new HashMap<ResourceLocation, Topping>();
    public final ResourceLocation location;
    public final boolean colorable;
    public final RegistryObject<Item> item;

    public Topping(ResourceLocation location, boolean colorable, RegistryObject<Item> item) {
        this.location = location;
        this.colorable = colorable;
        this.item = item;
        TOPPINGS.put(location, this);
    }

    public CompoundTag createTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.location.toString());
        this.addToTag(tag);
        return tag;
    }

    public int getColor() {
        if (!this.colorable) {
            return -1;
        }
        return 0;
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public ItemStack getItemstack() {
        return this.getItem().m_7968_();
    }

    public CompoundTag addToTag(CompoundTag original) {
        return original;
    }

    public Topping changeBasedOnTag(CompoundTag tag) {
        return this;
    }

    public Topping copy() {
        try {
            return (Topping)this.getClass().cast(this.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return Toppings.EMPTY;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Component getText() {
        return Component.m_237113_((String)"None");
    }

    public List<MobEffectInstance> editAppliedEffects(List<MobEffectInstance> effectInstances) {
        return effectInstances;
    }

    public static Topping readTag(CompoundTag tag) {
        ResourceLocation location = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
        if (location != null && TOPPINGS.get(location) != null) {
            return TOPPINGS.get(location).copy().changeBasedOnTag(tag);
        }
        return Toppings.EMPTY;
    }
}

